/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.client.block;

import java.util.function.Consumer;
import net.minecraft.class_10515;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11701;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5599;
import net.minecraft.class_5602;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_827;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.block.entity.LootrShulkerBlockEntity;
import noobanidus.mods.lootr.common.client.state.LootrShulkerBoxRenderState;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public class LootrShulkerBoxRenderer
implements class_827<LootrShulkerBlockEntity, LootrShulkerBoxRenderState> {
    public static final class_4730 MATERIAL = new class_4730(class_4722.field_21704, LootrAPI.rl("shulker"));
    public static final class_4730 MATERIAL2 = new class_4730(class_4722.field_21704, LootrAPI.rl("shulker_opened"));
    private final class_11701 materials;
    private final ShulkerBoxModel model;

    public LootrShulkerBoxRenderer(class_5614.class_5615 context) {
        this(context.comp_4539(), context.comp_4541());
    }

    public LootrShulkerBoxRenderer(class_10515.class_11695 context) {
        this(context.comp_3391(), context.comp_4551());
    }

    public LootrShulkerBoxRenderer(class_5599 modelSet, class_11701 materials) {
        this.materials = materials;
        this.model = new ShulkerBoxModel(modelSet.method_32072(class_5602.field_52997));
    }

    public void extractRenderState(LootrShulkerBlockEntity blockEntity, LootrShulkerBoxRenderState state, float partialTicks, class_243 position, @Nullable class_11683.class_11792 overlay) {
        super.method_74331((class_2586)blockEntity, (class_11954)state, partialTicks, position, overlay);
        state.field_62738 = blockEntity.getProgress(partialTicks);
        state.field_62736 = (class_2350)blockEntity.method_11010().method_61767((class_2769)class_2480.field_11496, (Comparable)class_2350.field_11036);
        state.vanilla = LootrAPI.isVanillaTextures();
        state.classic = false;
        state.visuallyOpen = class_310.method_1551().field_1724 != null && blockEntity.hasClientOpened(class_310.method_1551().field_1724.method_5667());
    }

    protected class_4730 getMaterial(LootrShulkerBoxRenderState state) {
        if (state.vanilla) {
            return class_4722.field_21710;
        }
        if (state.visuallyOpen) {
            return MATERIAL2;
        }
        return MATERIAL;
    }

    public LootrShulkerBoxRenderState createRenderState() {
        return new LootrShulkerBoxRenderState();
    }

    public void submit(LootrShulkerBoxRenderState state, class_4587 pose, class_11659 collector, class_12075 camera) {
        class_4730 material = this.getMaterial(state);
        this.submit(pose, collector, state.field_62676, class_4608.field_21444, state.field_62736, state.field_62738, state.field_62677, material, 0);
    }

    public void submit(class_4587 poseStack, class_11659 nodeCollector, int packedLight, int packedOverlay, class_2350 direction, float progress, @Nullable class_11683.class_11792 crumblingOverlay, class_4730 material, int outlineColor) {
        poseStack.method_22903();
        this.prepareModel(poseStack, direction, progress);
        nodeCollector.method_73490((class_3879)this.model, (Object)Float.valueOf(progress), poseStack, material.method_24146(arg_0 -> ((ShulkerBoxModel)this.model).method_23500(arg_0)), packedLight, packedOverlay, -1, this.materials.method_73030(material), outlineColor, crumblingOverlay);
        poseStack.method_22909();
    }

    private void prepareModel(class_4587 poseStack, class_2350 direction, float progress) {
        poseStack.method_46416(0.5f, 0.5f, 0.5f);
        poseStack.method_22905(0.9995f, 0.9995f, 0.9995f);
        poseStack.method_22907((Quaternionfc)direction.method_23224());
        poseStack.method_22905(1.0f, -1.0f, -1.0f);
        poseStack.method_46416(0.0f, -1.0f, 0.0f);
        this.model.setupAnim(Float.valueOf(progress));
    }

    public void getExtents(class_2350 direction, float progress, Consumer<Vector3fc> output) {
        class_4587 posestack = new class_4587();
        this.prepareModel(posestack, direction, progress);
        this.model.method_63512().method_72152(posestack, output);
    }

    public static class ShulkerBoxModel
    extends class_3879<Float> {
        private final class_630 lid;

        public ShulkerBoxModel(class_630 root) {
            super(root, class_12249::method_75994);
            this.lid = root.method_32086("lid");
        }

        public void setupAnim(Float renderState) {
            super.method_2819((Object)renderState);
            this.lid.method_2851(0.0f, 24.0f - renderState.floatValue() * 0.5f * 16.0f, 0.0f);
            this.lid.field_3675 = 270.0f * renderState.floatValue() * ((float)Math.PI / 180);
        }
    }
}

